/*
 * Decompiled with CFR 0.152.
 */
package net.endil.farmersutils.data;

import java.util.Arrays;
import net.endil.farmersutils.common.registry.FUBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FUBlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public FUBlockStates(DataGenerator output, ExistingFileHelper exFileHelper) {
        super(output, "farmersutils", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("farmersutils", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        for (RegistryObject blockRegistryObject : Arrays.asList(FUBlocks.APPLE_BAG, FUBlocks.BROWN_MUSHROOM_BAG, FUBlocks.COCOA_BEAN_BAG, FUBlocks.CRIMSON_FUNGUS_BAG, FUBlocks.GLOW_BERRY_BAG, FUBlocks.GOLDEN_APPLE_BAG, FUBlocks.RED_MUSHROOM_BAG, FUBlocks.SWEET_BERRY_BAG, FUBlocks.WARPED_FUNGUS_BAG, FUBlocks.PROPELPEARL_BAG)) {
            this.bag((RegistryObject<Block>)blockRegistryObject);
        }
        this.axisBlock((RotatedPillarBlock)FUBlocks.SUGAR_CANE_BALE.get());
        this.axisBlock((RotatedPillarBlock)FUBlocks.PROPELPLANT_CANE_BALE.get());
    }

    private void blockItem(RegistryObject<Block> block) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile("farmersutils:block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    private void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void bag(RegistryObject<Block> bag) {
        String Bag = this.blockName((Block)bag.get());
        this.simpleBlock((Block)bag.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Bag, "cube")).texture("particle", this.resourceBlock(Bag + "_top"))).texture("down", this.resourceBlock("bag_bottom"))).texture("up", this.resourceBlock(Bag + "_top"))).texture("north", this.resourceBlock("bag_side_tied"))).texture("south", this.resourceBlock("bag_side_tied"))).texture("east", this.resourceBlock("bag_side"))).texture("west", this.resourceBlock("bag_side")));
    }
}

